#!/bin/sh

devname=$1
mountpoint="/media/sda1"
outputlog="/var/log/vhcusbupdate.txt"
updatefile="vhcupdate*.tar.gz"

targzFileFound=0

echo "usb device $1 $ACTION" > $outputlog

if [ $ACTION = "add" ]
then
    echo "usb storage added. trying to mount! " 
#>> $outputlog
    /root/dbusvhccmd.sh flashDriveMounted

    if [ -d $mountpoint ]
    then
        echo "mount point $mountpoint exists!"  >> $outputlog
    else
        echo "creating mount point $mountpoint"  >> $outputlog
        /bin/mkdir $mountpoint
    fi

    echo "Mounting $1"  >> $outputlog
    /bin/mount -t auto /dev/$1 $mountpoint -o sync,exec

    for f in $mountpoint/$updatefile ; do
        if [ -e "$f" ]
        then
            echo "Update tar.gz $f found!"  >> $outputlog

            #send dbus message to UI application
            dbus-send --system \
                      --type=signal \
                      /VhcApplication \
                      com.manitowoc.DBus.VhcApplication.firmwareUpdateStarted

            targzFileFound=1
            # do process tar.gz here and execute script in it.
            cd $mountpoint
            /bin/tar -xf $updatefile
            updatedir=${f%".tar.gz"}
            if [ -d $updatedir ]
            then
                cd $updatedir
                if [ -e "updatescript.sh" ]
                then 
                    echo "Executing update script!"  >> $outputlog
                    ./updatescript.sh
                    #done with the update script
                    cd ../
                    echo "Done executing update script. Cleaning up!"  >> $outputlog
                    rm -r $updatedir
                else
                    echo "updatescript.sh not found!"  >> $outputlog
                fi
            fi
            break
        fi
    done

    if [ $targzFileFound = 0 ]
    then
        echo "No update tar.gz found! Trying with simple folder" 

        if [ -d "$mountpoint/vhcupdate" ]
        then
            #update directory exists
            echo "Update dir $mountpoint/vhcupdate found! Digging into it..."  >> $outputlog
            cd "$mountpoint/vhcupdate"
            if [ -e "productsList.txt" ]
            then 
                echo "found productsList.txt... copying it to /root/ "  >> $outputlog
                cp productsList.txt /root/productsList.txt
            fi

            if [ -e "morningDayPart.txt" ]
            then 
                echo "found morningDayPart.txt... copying it to /root/ "  >> $outputlog
                cp morningDayPart.txt /root/morningDayPart.txt
            fi

            if [ -e "eveningDayPart.txt" ]
            then 
                echo "found eveningDayPart.txt... copying it to /root/ "  >> $outputlog
                cp eveningDayPart.txt /root/eveningDayPart.txt
            fi

            if [ -e "vhclfb" ]
            then 
                echo "found vhclfb... copying it to /root/ "  >> $outputlog
                pkill vhc
                sleep 1
                cp vhclfb /root/vhclfb
								chmod 777 /root/vhclfb
            fi

            pkill vhc
            cd /root/
            /etc/init.d/S35vhc start

            echo "done with copying files... (if any)"  >> $outputlog
        fi
    fi
elif [ $ACTION = "remove" ]
then
    echo "Unmounting $1"  >> $outputlog
    /root/dbusvhccmd.sh flashDriveNotMounted
    /bin/umount $mountpoint
fi

