#!/bin/sh

# Check if BSP version is correct
if [ ! -e /root/BSP_ver_6_*.txt ]
then
    echo "BSP detected is not UX UI"
    exit 1
fi

# kill the vhc application
pkill vhc

#updateDir=$(dirname -- "$(readlink -f -- "${BASH_SOURCE[0]}")")
#cd "$updateDir"

#Update UI file Id (the CFG_***.hcc)
#rm /root/CFG*
#sync
#cp ./contents/CFG* /root/
#sync

#remove the logs
#rm /var/log/messages
#sync

#disable system/kernel logging
#sed -i '/messages/'d /etc/syslog.conf

# updates folders creation
if [ ! -d "/root/updates" ]; then
    mkdir /root/updates
    mkdir /root/updates/menu
    mkdir /root/updates/firmware
fi

if [ -d "updates" ]; then
    cp -r updates/* /root/updates/
    /bin/sync
fi


# preloaded menu folder creation
if [ ! -d "/root/preloadedMenus" ]; then
    mkdir /root/preloadedMenus
fi

if [ ! -d "/root/preloadedConfigs" ]; then
    mkdir /root/preloadedConfigs
fi


if [ -d "preloadedConfigs" ]; then
    cp -r preloadedConfigs/* /root/preloadedConfigs/
    /bin/sync
fi


#now copy all menuConnect files included in this package on the host.
if [ -d "menu" ]; then
    cp -r menu/* /root/preloadedMenus/
    /bin/sync
fi

# make sure this is updated 
# based on the update package
if [ -d "etc" ]; then
  cp -r etc/* /etc/
  /bin/sync
fi

if [ -d "root" ]; then
  cp -r root/* /root/
  /bin/sync
fi

#Disable send performance data by setting the value to 0
/bin/sed -i 's/performanceDataInterval=.*/performanceDataInterval=0/g' /root/config.txt

#Make sure NTP is enabled
/bin/sed -i 's/ntpOn=.*/ntpOn=1/g' /root/config.txt

#Disable pan messages. Check if parameter is exist and modify it or add the parameter if it is missing
grep -q -F 'panMessagesEnable' /root/config.txt

if [ $? -ne 0 ]; then
  #echo "Add non-existing value"
  sed -i '$apanMessagesEnable=0' /root/config.txt
#else
#  #echo "Modify existing value"
#  /bin/sed -i 's/panMessagesEnable=.*/panMessagesEnable=0/g' /root/config.txt
fi

/bin/sync

#if [ -d "usr" ]; then
#  cp -r usr/* /usr
#  /bin/sync
#  rm -f /usr/lib/libjson-c.so
#  ln -s /usr/lib/libjson-c.so.4.0.0 /usr/lib/libjson-c.so
#  rm -f /usr/lib/libjson-c.so.3
#  ln -s /usr/lib/libjson-c.so.4.0.0 /usr/lib/libjson-c.so.3
#fi

#Initialize RS485 port, CAN bus and run the update utility
stty -F /dev/ttyO1 -crtscts speed 115200 rs485 rs485rtsonsend

ip link set can0 up type can bitrate 500000

ifconfig can0 up

./vhcSystemUpdateUtil -idConnector1 -autoinstall 

echo "Clean the update folder ..."
rm -rf /root/updates/firmware/*

/bin/sync

# reboot the system - this will be an indication that the update was successful
#/sbin/reboot
