#!/bin/sh

# Check if BSP version is correct
if [ ! -e /root/BSP_ver_5_*.txt ]
then
    echo "BSP detected is not UX UI"
    exit 1
fi

if [ -e "/root/dbus_iot_monitor.sh" ]
then
  pkill dbus_iot
  sleep 1
  rm /root/dbus_iot_monitor.sh
  /bin/sync
fi

if [ -e "/etc/init.d/vhcdbusiotmonitor" ]
then
  rm /etc/init.d/vhcdbusiotmonitor
  /bin/sync
fi

# kill the vhc application
pkill vhc

#updateDir=$(dirname -- "$(readlink -f -- "${BASH_SOURCE[0]}")")
#cd "$updateDir"

#remove the logs
#rm /var/log/messages
#sync

#disable system/kernel logging
#sed -i '/messages/'d /etc/syslog.conf

# updates folders creation
if [ ! -d "/root/updates" ]; then
    mkdir /root/updates
    mkdir /root/updates/menu
    mkdir /root/updates/firmware
fi

if [ -d "updates" ]; then
    cp -r updates/* /root/updates/
    /bin/sync
fi

# preloaded menu folder creation
if [ ! -d "/root/preloadedMenus" ]; then
    mkdir /root/preloadedMenus
fi

#now copy all menuConnect files included in this package on the host.
if [ -d "menu" ]; then
    cp -r menu/* /root/preloadedMenus/
    /bin/sync
fi

# make sure this is updated 
# based on the update package
if [ -d "etc" ]; then
  cp -r etc/* /etc/
  /bin/sync
fi

if [ -d "root" ]; then
  cp -r root/* /root/
  /bin/sync
fi

#Disable send performance data by setting the value to 0
/bin/sed -i 's/performanceDataInterval=.*/performanceDataInterval=0/g' /root/config.txt

#Make sure NTP is enabled
/bin/sed -i 's/ntpOn=.*/ntpOn=1/g' /root/config.txt

if [ $? -ne 0 ]; then
  #echo "Add non-existing value"
  sed -i '$apanMessagesEnable=0' /root/config.txt
#else
#  #echo "Modify existing value"
#  /bin/sed -i 's/panMessagesEnable=.*/panMessagesEnable=0/g' /root/config.txt
fi

/bin/sync

/usr/sbin/canconfig can0 stop
/usr/sbin/canconfig can0 bitrate 500000
/usr/sbin/canconfig can0 start
/root/enable_audio
/root/enable_audio_hi



export TSLIB_TSEVENTTYPE=INPUT
export TSLIB_TSDEVICE=/dev/input/event0
export TSLIB_CALIBFILE=/etc/pointercal
export TSLIB_CONFFILE=/etc/ts.conf
export TSLIB_PLUGINDIR=/usr/lib/ts
export TSLIB_FBDEVICE=/dev/fb0
export TSLIB_CONSOLEDEVICE=none
export QWS_MOUSE_PROTO=tslib:/dev/input/event0
export PATH=$PATH:/usr/bin

./vhcSystemUpdateUtil -idConnector1 -autoinstall -platform linuxfb -plugin tslib:/dev/input/event0 -tp=/root

echo "Clean the update folder ..."
rm -rf /root/updates/firmware/*

/bin/sync

# reboot the system - this will be an indication that the update was successful
#/sbin/reboot
